/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class RegistryCommand {
    private static final long PAGE_SIZE = 8L;
    private static final ResourceKey<Registry<Registry<?>>> ROOT_REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("root"));
    private static final DynamicCommandExceptionType UNKNOWN_REGISTRY = new DynamicCommandExceptionType(key -> Component.m_237110_((String)"commands.supplementaries.registry.error.unknown_registry", (Object[])new Object[]{key.toString()}));

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"registry").requires(cs -> cs.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"registry", (ArgumentType)ResourceKeyArgument.m_212386_(ROOT_REGISTRY_KEY)).suggests(RegistryCommand::suggestRegistries).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list").executes(ctx -> RegistryCommand.listElements((CommandContext<CommandSourceStack>)ctx, 1, null))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> RegistryCommand.listElements((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"), null))))).then(Commands.m_82127_((String)"search").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"keyword", (ArgumentType)StringArgumentType.string()).executes(ctx -> RegistryCommand.listElements((CommandContext<CommandSourceStack>)ctx, 1, StringArgumentType.getString((CommandContext)ctx, (String)"keyword")))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> RegistryCommand.listElements((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"), StringArgumentType.getString((CommandContext)ctx, (String)"keyword")))))));
    }

    private static int listElements(CommandContext<CommandSourceStack> ctx, int page, @Nullable String search) throws CommandSyntaxException {
        ResourceKey<Registry<?>> registryKey = RegistryCommand.getResourceKey(ctx, "registry", ROOT_REGISTRY_KEY).orElseThrow();
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        Registry registry = (Registry)source.m_81377_().m_206579_().m_6632_(registryKey).orElseThrow(() -> UNKNOWN_REGISTRY.create((Object)registryKey.m_135782_()));
        long elementCount = registry.m_13562_();
        source.m_288197_(() -> RegistryCommand.createMessage(Component.m_237110_((String)"commands.supplementaries.registry.registry_key", (Object[])new Object[]{Component.m_237113_((String)registryKey.m_135782_().toString()).m_130940_(ChatFormatting.GOLD)}), page, () -> registry.m_6566_().stream().map(ResourceLocation::toString), search), false);
        return (int)elementCount;
    }

    private static MutableComponent createMessage(MutableComponent header, long currentPage, Supplier<Stream<String>> names, @Nullable String search) {
        List<String> filtered = names.get().filter(s -> search == null || s.contains(search)).toList();
        long count = filtered.size();
        String allElementNames = filtered.stream().sorted().collect(Collectors.joining("\n"));
        long totalPages = (count - 1L) / 8L + 1L;
        long actualPage = (long)Mth.m_14036_((float)currentPage, (float)1.0f, (float)totalPages);
        MutableComponent component = Component.m_237110_((String)"commands.supplementaries.registry.elements_count", (Object[])new Object[]{count});
        if (count > 0L) {
            component = ComponentUtils.m_130748_((Component)component.m_130938_(s -> s.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, allElementNames)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"commands.supplementaries.registry.copy_elements_names")))));
            component = Component.m_237110_((String)"commands.supplementaries.registry.page_info", (Object[])new Object[]{component, actualPage, totalPages});
        }
        MutableComponent tagElements = Component.m_237113_((String)"").m_7220_((Component)component);
        Stream<MutableComponent> stream = filtered.stream().sorted().skip(8L * (actualPage - 1L)).limit(8L).map(Component::m_237113_).map(t -> t.m_130940_(ChatFormatting.DARK_GREEN)).map(t -> Component.m_237115_((String)"\n - ").m_7220_((Component)t));
        Objects.requireNonNull(tagElements);
        stream.forEach(arg_0 -> ((MutableComponent)tagElements).m_7220_(arg_0));
        return header.m_130946_("\n").m_7220_((Component)tagElements);
    }

    private static CompletableFuture<Suggestions> suggestRegistries(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        Stream<String> strings = ((CommandSourceStack)ctx.getSource()).m_5894_().m_206193_().map(RegistryAccess.RegistryEntry::f_206233_).map(ResourceKey::m_135782_).map(ResourceLocation::toString);
        Objects.requireNonNull(builder);
        strings.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static <T> Optional<ResourceKey<T>> getResourceKey(CommandContext<CommandSourceStack> ctx, String name, ResourceKey<Registry<T>> registryKey) {
        ResourceKey key = (ResourceKey)ctx.getArgument(name, ResourceKey.class);
        return key.m_195975_(registryKey);
    }
}

